@extends('layouts.app')

@section('title', 'Video Consultation')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <h1 class="text-3xl font-bold text-gray-800">Video Consultation</h1>
        <a href="{{ route('doctor.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-xl font-bold mb-4">Appointment Details</h2>
        <p><strong>Patient:</strong> {{ $appointment->patient->full_name }}</p>
        <p><strong>Room ID:</strong> {{ $appointment->video_call_room_id }}</p>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Video Call Provider</label>
            <select id="videoProvider" class="w-full px-3 py-2 border rounded">
                <option value="jitsi">Jitsi Meet</option>
                <option value="google">Google Meet</option>
            </select>
        </div>

        @if($appointment->video_call_room_id)
            <div id="jitsi-container" style="width: 100%; height: 600px; position: relative; background: #f3f4f6;">
                <div id="jitsi-logo-overlay" style="position: absolute; top: 0; left: 0; width: 200px; height: 60px; background: #ffffff; z-index: 1000; cursor: default;"></div>
            </div>
            <div id="google-meet-container" class="hidden">
                <iframe 
                    id="googleMeetFrame"
                    allow="camera; microphone; fullscreen; speaker; display-capture"
                    style="width: 100%; height: 600px; border: none;">
                </iframe>
            </div>
        @else
            <div class="bg-yellow-50 border border-yellow-200 rounded p-6 text-center">
                <p class="text-yellow-800 font-semibold">No video call room ID available for this appointment.</p>
                <p class="text-yellow-600 mt-2">Please contact support or create a new appointment.</p>
            </div>
        @endif
    </div>
</div>

<script src="https://8x8.vc/external_api.js"></script>
<script>
    let jitsiApi = null;
    const roomName = '{{ $appointment->video_call_room_id }}';
    
    function initJitsi() {
        const domain = 'meet.jit.si';
        const options = {
            roomName: roomName,
            width: '100%',
            height: 600,
            parentNode: document.querySelector('#jitsi-container'),
            configOverwrite: {
                startWithAudioMuted: false,
                startWithVideoMuted: false,
            },
        };

        jitsiApi = new JitsiMeetExternalAPI(domain, options);

        jitsiApi.addEventListener('videoConferenceJoined', () => {
            console.log('Joined Jitsi video conference');
        });

        jitsiApi.addEventListener('videoConferenceLeft', () => {
            console.log('Left Jitsi video conference');
            window.location.href = '{{ route("doctor.appointments") }}';
        });
    }

    function initGoogleMeet() {
        const meetUrl = `https://meet.google.com/${roomName}`;
        document.getElementById('googleMeetFrame').src = meetUrl;
    }

    // Block clicks on Jitsi logo overlay
    const overlay = document.getElementById('jitsi-logo-overlay');
    if (overlay) {
        overlay.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            return false;
        });
    }

    @if($appointment->video_call_room_id)
    initJitsi();
    @endif

    @if($appointment->video_call_room_id)
    document.getElementById('videoProvider').addEventListener('change', function() {
        if (this.value === 'jitsi') {
            document.getElementById('jitsi-container').style.display = 'block';
            document.getElementById('google-meet-container').classList.add('hidden');
            if (!jitsiApi) {
                initJitsi();
            }
            // Show overlay when switching to Jitsi
            const overlay = document.getElementById('jitsi-logo-overlay');
            if (overlay) overlay.style.display = 'block';
        } else {
            document.getElementById('jitsi-container').style.display = 'none';
            document.getElementById('google-meet-container').classList.remove('hidden');
            if (jitsiApi) {
                jitsiApi.dispose();
                jitsiApi = null;
            }
            initGoogleMeet();
            // Hide overlay when switching to Google Meet
            const overlay = document.getElementById('jitsi-logo-overlay');
            if (overlay) overlay.style.display = 'none';
        }
    });
    @endif
</script>
@endsection
